### 实验名称

实验2.2 NFC读写

### 实验目的

通过该实验的学习与实践：

了解NFC识别及数据的读写

### 实验背景

​		近场通信（Near Field Communication，简称NFC）是一种无线通信技术，允许设备在短距离内（通常在10厘米以内）进行数据交换。NFC技术基于射频识别（RFID）原理，但与RFID相比，NFC具有更高的交互性和双向通信能力。这种技术的发展，得益于无线通信技术的快速进步和消费者对便捷性需求的增长。

​		NFC技术最初在1990年代末由飞利浦和索尼共同开发，目的是创造一种能够简化无线设备间数据传输的解决方案。随着智能手机和其他便携式设备的普及，NFC技术得到了广泛的应用，包括移动支付、门禁控制、智能交通卡和个人身份验证等。此外，随着物联网（IoT）和智能家居的发展，NFC技术的应用范围正在不断扩大。它不仅可以用于简单的数据传输，还可以作为设备间智能交互的桥梁，实现更加自动化和个性化的用户体验。

​		NFC技术的优势在于其简单性、快速性和安全性。用户只需将设备靠近NFC标签或另一台NFC设备，即可实现数据的快速传输。此外，NFC技术还支持多种安全机制，如加密通信和数据签名，以保护传输过程中的数据安全。

### 实验原理

​		我们使用的NFC卡为M1卡，又叫Mifare One。其容量1KB 的 EEPROM（Electrically Erasable Programmable Read-Only Memory，带电可擦可编程只读存储器）。

​		M1卡分为16个扇区，每个扇区4块（块0～3），共64块，按块号编址为0～63。第0扇区的块0（即绝对地址0块）用于存放厂商代码，已经固化，不可更改。其他各扇区的块0、块1、块2为数据块，用于存贮数据；块3为控制块，存放密码A、存取控制、密码B。每个扇区的密码和存取控制都是独立的，可以根据实际需要设定各自的密码及存取控制。存贮结构如下表所示：

![22](pic/22.jpg)

​		NFC在读取卡片信息之前，要寻卡，识别卡（获取卡号），使用要读的数据块所在扇区的密码进行验证，验证通过后，NFC才可从数据块中读取数据。同理，写入数据前，NFC要进行寻卡，识别卡，验证密码的过程，之后才能往数据块中写入数据。

### 实验环境

Windows 10

Keil 5.39

小米实训箱

### 建议课时

4课时

### 实验步骤

一、文件下载

复制链接到浏览器下载数据。

http://10.90.3.2/LMS/AIOT/Intro/2.2/U1-S5-E1-read.zip

http://10.90.3.2/LMS/AIOT/Intro/2.2/U1-S5-E1-write.zip

二、环境准备

1. 实验软硬件环境

   软件环境：Keil

   硬件环境：母板及其配套数据线，U1子板一个，S5子板一个，E1子板一个，NFC卡一张。

2. 实验硬件堆叠方式

   ![1](pic/1.png)

   ​												图1 实验U1-S5-E1-write硬件堆叠

3. NFC卡放置方式

   ![3](pic/3.png)

   ​																图2 卡片摆放方式

4. 搭环境

   按照上述图1方式搭好硬件环境。连接烧录器GD-LINK调试器USB端连接到PC，Micro-USB端插入母板#0位置上方的Micro-USB口中。长按母板电源键给系统上电。按照图2放置卡片到指定位置。

   ![2](pic/2.jpg)

三、实验运行步骤

1. NFC写入

（1）打开软件工程

解压U1-S5-E1-write.zip，打开Keil软件，在软件中打开U1-S5-E1-write工程文件（**U1-S5-E1-write\demo\Project\KEIL_Project\U1+S5+E1-GD32470Z.uvprojx**）。

![4](pic/4.jpg)

![5](pic/5.jpg)

（2）修改写入内容

点击View—>Project Window打开Project窗口。

![7](pic/7.jpg)

点击Application—>main.c，找到红框部分，修改数值为当前时间。

![6](pic/6.jpg)

例如，当前为9:31，则等号右边为：{0,9,3,1}，修改后：

![8](pic/8.jpg)

（3）编译

按下快捷键F7，或者点击build按钮编译工程。

![9](pic/9.jpg)

![11](pic/11.jpg)

（4）下载

按下F8快捷键，或者点击load按钮下载程序到硬件。

![10](pic/10.jpg)

![12](pic/12.jpg)

（5）查看结果

看到数码管显示卡片信息（这个过程较快注意观察），为识别卡片成功。之后程序将进行NFC数据写入，数码管归零，为写操作结束。（若始终未显示卡片信息，或始终显示“0000”，请调整卡片位置，并从步骤三、1 “NFC写入”开始重复操作）

卡片信息：03AA

**（不同卡片此处信息可能不一样）**

![13](pic/13.jpg)

写操作结束：

![14](pic/14.jpg)

（6）程序擦除

（如擦除后数码管常亮，为正常现象）

![15](pic/15.jpg)

2. NFC读取

（1）打开软件工程

解压U1-S5-E1-read.zip，打开Keil软件，在软件中打开U1-S5-E1-read工程文件（**U1-S5-E1-read\demo\Project\KEIL_Project\U1+S5+E1-GD32470Z.uvprojx**）。

![16](pic/16.jpg)

![17](pic/17.jpg)

（2）编译

按下快捷键F7，或者点击build按钮编译工程。

![9](pic/9.jpg)

![18](pic/18.jpg)

（3）下载

按下F8快捷键，或者点击load按钮下载程序到硬件。

![10](pic/10.jpg)

![19](pic/19.jpg)

（4）查看结果

看到数码管显示卡片信息（这个过程较快注意观察），为识别卡片成功。之后程序将进行NFC数据读取，数码管显示上一步写入的时间信息即为读取成功。若能够看到卡片信息，但之后变为显示“0000”则读取失败，请从步骤三、1 “NFC写入”开始重复操作；若始终显示“0000”，则可能未识别到卡片，请调整卡片位置，并从步骤三、2 “NFC读取”开始重复操作。

卡片信息：03AA

（不同卡片此处显示可能不同）

![20](pic/20.jpg)

读取成功：0931

**（此处显示第二、(2) “修改写入内容” 步，写入的信息）**

![21](pic/21.jpg)

（5）程序擦除

（擦除后，数码管保持擦除前的信息，为正常现象）

![15](pic/15.jpg)

（6）长按母板电源键关闭系统，拔下Micro-USB。之后，可取下子板。

### 实验总结

本实验介绍了NFC卡的储存原理、进行了NFC的读写操作实验，通过本实验希望同学们能够熟悉NFC的读写过程。